% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_annotation.R
\name{read_annotation}
\alias{read_annotation}
\title{Read Freesurfer annotation file}
\usage{
read_annotation(path, verbose = TRUE)
}
\arguments{
\item{path}{path to annotation file, usually with extension \code{annot}}

\item{verbose}{logical.}
}
\value{
list of 3 with vertices, labels, and colortable
}
\description{
Reads Freesurfer binary annotation files
that contain information on vertex labels
and colours for use in analyses and
brain area lookups.
}
\details{
This function is heavily
based on Freesurfer's read_annotation.m
Original Author: Bruce Fischl
CVS Revision Info:
    $Author: greve $
    $Date: 2014/02/25 19:54:10 $
    $Revision: 1.10 $
}
\examples{
if (have_fs()) {
    bert_dir = file.path(fs_subj_dir(), "bert")
    annot_file = file.path(bert_dir, "label", "lh.aparc.annot")
    res = read_annotation(annot_file)
} 
}
