% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_na.R
\name{fill_na}
\alias{fill_na}
\title{Fill NAs}
\usage{
fill_na(.data, ..., fill = 0L, missing_type = c("all", "NA", "NaN", "Inf"))
}
\arguments{
\item{.data}{data frame}

\item{...}{tidyselect specification. Default selection: none}

\item{fill}{value to fill missings}

\item{missing_type}{character vector. Choose what type of missing to fill. Default is all types. choose from "all", "Na", "NaN", "Inf"}
}
\value{
data frame
}
\description{
use tidyselect to fill \code{NA} values
Default behavior is to fill all integer or double columns cols with 0, preserving their types.
}
\examples{

tibble::tibble(x = c(NA, 1L, 2L, NA, NaN, 5L, Inf)) -> tbl

tbl \%>\%
  fill_na()

tbl \%>\%
 fill_na(fill = 1L, missing_type = "Inf")

tbl \%>\%
 fill_na(missing_type = "NaN")

}
