% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_na.R
\name{make_na}
\alias{make_na}
\title{Make NAs}
\usage{
make_na(.data, ..., vec = c("-", "", " ", "null"))
}
\arguments{
\item{.data}{data frame}

\item{...}{tidyselect. Default selection: all chr cols}

\item{vec}{vector of possible elements to replace with NA}
}
\value{
data frame
}
\description{
Set elements to NA values using tidyselect specification.
Don't use this function on columns of different modes at once.
Defaults to choosing all character columns.
}
\examples{

# easily set NA values. blank space and empty space are default options

tibble::tibble(x = c("a", "b", "", "d", " ", "", "e")) \%>\%
   make_na()

}
