% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfpi.R
\name{WFPI}
\alias{WFPI}
\title{WFPI - Weighted Frequent Pattern Isolation algorithm}
\usage{
WFPI(data, minSupport = 0.3, mlen = 0, preferredColumn = "",
  preference = 1, noCores = 1)
}
\arguments{
\item{data}{\code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{minSupport}{minimum support for FPM}

\item{mlen}{maximum length of frequent itemsets}

\item{preferredColumn}{column name that is preferred}

\item{preference}{numeric value that multiplies the score}

\item{noCores}{number of cores for parallel computation}
}
\value{
model output (list) with all results including outlier scores
}
\description{
Algorithm proposed by:
J. Kuchar, V. Svatek: Spotlighting Anomalies using Frequent Patterns, Proceedings of the KDD 2017 Workshop on Anomaly Detection in Finance, Halifax, Nova Scotia, Canada, PMLR, 2017.
}
\examples{
library("fpmoutliers")
dataFrame <- read.csv(
     system.file("extdata", "fp-outlier-customer-data.csv", package = "fpmoutliers"))
model <- WFPI(dataFrame, minSupport = 0.001, preferredColumn="Car", preference=10)
}
