% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_lines}
\alias{plot_lines}
\title{Display means conditionnally on some other values}
\usage{
plot_lines(fml, data, time, moderator, smoothing_window = 0, fun,
  col = "set1", lty = 1, pch = c(19, 17, 15, 8, 5, 4, 3, 1),
  legend_options = list(), pt.cex = 2, lwd = 2,
  dict = getFplot_dict(), mod.title, ...)
}
\arguments{
\item{fml}{A formula of the type \code{variable ~ time | moderator}. Note that the moderator is optional. Can also be a vector representing the elements of the variable If a formula is provided, then you must add the argument \sQuote{data}.}

\item{data}{Data frame containing the variables of the formula. Used only if the argument \sQuote{fml} is a formula.}

\item{time}{Only if argument \sQuote{fml} is a vector. It should be the vector of \sQuote{time} identifiers to average over.}

\item{moderator}{Only if argument \sQuote{fml} is a vector. It should be a vector of conditional values to average over. This is an optional parameter.}

\item{smoothing_window}{Default is 0. The number of time periods to average over. Note that if it is provided the new value for each period is the average of the current period and the \code{smoothing_window} time periods before and after.}

\item{fun}{Function to apply when aggregating the values on the time variable. Default is \code{mean}.}

\item{col}{The colors. Either a vector or a keyword (\dQuote{Set1} or \dQuote{paired}). By default those are the \dQuote{Set1} colors colorBrewer. This argument is used only if there is a moderator.}

\item{lty}{The line types, in the case there are more than one moderator. By default it is equal to 1 (ie no difference between moderators).}

\item{pch}{The form types of the points, in the case there are more than one moderator. By default it is equal to \8code{c(19, 17, 15, 8, 5, 4, 3, 1)}.}

\item{legend_options}{A list containing additional parameters for the function \code{\link[graphics]{legend}} -- only concerns the moderator. Not that you can set the additionnal arguments \code{trunc} and \code{trunc.method} which relates to the number of characters to show and the truncation method. By default the algorithm truncates automatically when needed.}

\item{pt.cex}{Default to 2. The \code{cex} of the points.}

\item{lwd}{Default to 2. The width of the lines.}

\item{dict}{A dictionnary to rename the variables names in the axes and legend. Should be a named vector. By default it s the value of \code{getFplot_dict()}, which you can set with the function \code{\link[fplot]{setFplot_dict}}.}

\item{mod.title}{Character scalar. The title of the legend, in case there is a moderator. By default it is the moderator name modified by dict if the moderator is numeric (otherwise default is empty). To display no title, set it to \code{NULL}.}

\item{...}{Other arguments to be passed to the function \code{plot}.}
}
\description{
The typical use of this function is to represents trends of average along some categorical variable.
}
\examples{

df = iris
df$period = sample(1:4, 150, TRUE)

plot_lines(Petal.Length ~ period|Species, df)

plot_lines(Petal.Length ~ Species, df)


}
\author{
Laurent Berge
}
