% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revise_ranges.R
\name{revise_ranges}
\alias{revise_ranges}
\title{revise_ranges}
\usage{
revise_ranges(
  x,
  y,
  assemblage = "collection_no",
  srt = "max_ma",
  end = "min_ma",
  taxon = "genus",
  err = NULL,
  do.flag = FALSE,
  prop = 0.75,
  allow.zero = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{Fossil occurrence data grouped into
spatiotemporally distinct assemblages}

\item{y}{A stratigraphic range dataset from which
consensus assemblage ages will be derived}

\item{assemblage}{The column name of the assemblage
groups in x}

\item{srt}{The column name of stratigraphic bases for
each element in both x and y - i.e. x and y must have
this same name for that column}

\item{end}{The column name of stratigraphic tops for
each element in both x and y - i.e. x and y must have
this same name for that column}

\item{taxon}{The column name denoting the taxon names
in both x and y - i.e. x and y must have
this same name for that column}

\item{err}{The column name flagging age errors for
occurrences in x. This allows 100$ valid assemblages to
be skipped. Age errors can be derived using @seealso
flag_ranges. All error codes must be one of: "000" -
unchecked, "R1R" - valid, "0R0" - both FAD and LAD exceeded,
"00R" - totally older than range, "R00" - totally younger
than range, "01R" - FAD exceeded, "1R0" - LAD exceeded.
If not supplied, all assemblages will be checked, even if
they are already valid a priori.}

\item{do.flag}{Rather than supplying error codes, should
flag_ranges be called internally to generate error codes
for supply to the rest of revise_ranges? As with err, this
is useful to prefilter individual occurrences, allowing
assemblages contain all valid, all unchecked or a mixture
of such error codes to be skipped. This can massively speed
up processing time for large datasets.}

\item{prop}{A numeric, between 0 and 1, denoting the
threshold percentage of taxa in the assemblage for
which a consensus age must be found}

\item{allow.zero}{A logical determining if, in the
case of a collection LAD being equal to the consensus
age FAD (i.e. a pointwise overlap), that pointwise
age will be taken as the revised age. The resultant
collection age will have no uncertainty as a result,
which may be unrealistic. The default behaviour is
FALSE, in which case pointwise overlaps will be
ignored and the revised age taken instead}

\item{verbose}{A logical determining if the progress
of the redating procedure should be reported}
}
\value{
A list of two dataframes, the first recording
the results of the consensus redating procedure for
each assemblage in x, the second recording any flags
(if any) for each occurrence in x
}
\description{
Function to generate a consensus age for assemblages
of fossil data in x, given a table of taxonomic
ranges. The need for error-checking is informed by
the error codes for the individual fossil
occurrences within each collection - if there is no
error, then the consensus age is unchanged. If
errors are present, then a consensus age for a
threshold proportion of taxa is searched for using
the overlap of the ranges for those taxa, as given
in range table y. Taxa whose occurrences lie outside
this consensus age are flagged as potential taxonomic
errors. If the threshold consensus partially overlaps
with the assemblage age, this overlap is returned to
present overzealous alteration of the age - otherwise
the complete consensus age is returned. If a
consensus age cannot be found, the original assemblage
age is returned, and each occurrence in the collection
flagged as potential taxonomic errors.
}
\examples{
# load datasets
data("brachios")
data("sepkoski")
# subsample brachios to make for a short example runtime
set.seed(1)
brachios <- brachios[sample(1:nrow(brachios), 1000),]
# rename columns in Sepkoski to match brachios
colnames(sepkoski)[4:6] <- c("genus", "max_ma", "min_ma")
# flag and resolve against the Sepkoski Compendium, collection-wise
revrng <- revise_ranges(x = brachios, y = sepkoski, do.flag = TRUE, verbose = TRUE,
                        taxon = "genus", assemblage = "collection_no",
                        srt = "max_ma", end = "min_ma")
# append the revised occurrence ages and error codes to the dataset
brachios$newfad <- revrng$occurrence$FAD
brachios$newlad <- revrng$occurrence$LAD
brachios$errcode <- revrng$occurence$status
}
