% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_fetch_mdl}
\alias{FM_fetch_mdl}
\title{Fetches Models from Modules in the App}
\usage{
FM_fetch_mdl(state, session, ids = NULL)
}
\arguments{
\item{state}{Current module state after yaml file has been read}

\item{session}{Shiny session variable}

\item{ids}{Vector of ID strings for the modules containing models or
NULL for all modules with models available.}
}
\value{
list containing the current dataset with the following format:
JMH
\itemize{
  \item{isgood:} Boolean indicating the whether a dataset was found
  (\code{FALSE})
  \item{catalog:} Dataframe containing the a tabular catalog of the
  models found.
  \itemize{
    \item{label:} Text label
  }
  \item{modules:} List with an entry for each module..
}
}
\description{
Loops through each specified module ID or all modules if no ID
was specified. For each ID, an attempt will be made to extract any models
available.
}
\examples{
# We need a module state and a Shiny session variable
# to use this function:
id="UD"
sess_res = UD_test_mksession(session=list(), id=id)
session = sess_res$session
state   = sess_res$state
mdl = FM_fetch_mdl(state, session)
mdl$catalog
}
