% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{icontext}
\alias{icontext}
\title{Create icon-text elements}
\usage{
icontext(icon, text = list(NULL), ..., simplify = TRUE,
  provider = getOption("formattable.icon.provider", "glyphicon"),
  class_template = getOption("formattable.icon.class_template",
  "{provider} {provider}-{icon}"))
}
\arguments{
\item{icon}{a character vector or list of character vectors
of icon names.}

\item{text}{a character vector of contents.}

\item{...}{additional parameters (reserved)}

\item{simplify}{logical to indicating whether to return
the only element if a single-valued list is resulted.}

\item{provider}{the provider of icon set.}

\item{class_template}{a character value to specifiy to template of the class
with \code{"{provider}"} to represent \code{provider} value and \code{"{icon}"} to
represent \code{icon} values.}
}
\description{
Create icon-text elements
}
\examples{
icontext("plus")
icontext(c("star","star-empty"))
icontext(ifelse(mtcars$mpg > mean(mtcars$mpg), "plus", "minus"), mtcars$mpg)
icontext(list(rep("star",3), rep("star",2)), c("item 1", "item 2"))
}
\seealso{
\href{http://getbootstrap.com/components/#glyphicons}{Glyphicons in Bootstrap},
\href{http://glyphicons.com/}{Glyphicons}
}

