% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_plot.R
\name{edit_plot}
\alias{edit_plot}
\title{Edit forest plot}
\usage{
edit_plot(
  plot,
  row = NULL,
  col = NULL,
  part = c("body", "header"),
  which = c("text", "background", "ci"),
  gp
)
}
\arguments{
\item{plot}{A forest plot object.}

\item{row}{A numeric value or vector indicating row number to edit in the
dataset. Will edit the whole row if left blank for the body. This will be
ignored if the \code{part} is "header".}

\item{col}{A numeric value or vector indicating column to edit in the dataset.
Will edit the whole column if left blank.}

\item{part}{Part to edit, \code{"body"} (default) or \code{"header"}.}

\item{which}{Which element to edit, \code{"text"}, \code{"background"} or
\code{"ci"} (confidence interval). This will not edit diamond shaped summary
CI, please change it with \code{\link{forest_theme}}.}

\item{gp}{Pass \code{gpar} parameters, see \code{\link[grid]{gpar}}. It should
be passed as \code{gpar(col = "red")}. For \code{which = "ci"}, please refer to
\code{\link{forest_theme}} \code{ci_*} parameters for the editable elements.}
}
\value{
A \code{\link[gtable]{gtable}} object.
}
\description{
This function is used to edit the graphical parameter of text and background
of the forest plot.
}
\seealso{
\code{\link[grid]{gpar}} \code{\link[grid]{editGrob}} \code{\link{forest_theme}}
}
