% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid_plot.R
\name{resid_plot}
\alias{resid_plot}
\title{Calculate residual values and create plots}
\usage{
resid_plot(df, obs, ..., type = "scatterplot", point_size = 3,
  color = NA, nrow = NA, ncol = NA, lim_y = NA,
  xlab = "Observed values", clab = NA, font = "serif",
  legend_pos = "bottom", gray_scale = TRUE, res_table = FALSE)
}
\arguments{
\item{df}{A data frame.}

\item{obs}{Quoted name of the observed values variable.}

\item{...}{Quoted name(s) for the estimated values variable(s). Multiple variables must be separated by comma.}

\item{type}{Character object for the type of plot created, The available plots are: \code{"scatterplot"}, \code{"histogram"}, \code{"histogram_curve"} and \code{"versus"}. Default: \code{"scatterplot"}.}

\item{point_size}{Numeric value for the point size in scatter plots. Default: \code{3}.}

\item{color}{Quoted name of a variable. If supplied, this variable will be used to classify the data by color. Default: \code{NA}.}

\item{nrow}{Numeric value for number of rows in the plot matrix. If not supplied, the plots will be automatically sorted. Default: \code{NA}.}

\item{ncol}{Numeric value for number of columns in the plot matrix. If not supplied, the plots will be automatically sorted. Default: \code{NA}.}

\item{lim_y}{Numeric value for the y axis upper and lower limit. If \code{NA}, the biggest residual value is used. Default: \code{NA}.}

\item{xlab}{Character value for the x label used in some plots. Default: \code{"Observed values"}.}

\item{clab}{Character value for the color label used, if a color variable is supplied. If not supplied, the \code{color} variable name will be used. Default: \code{NA}.}

\item{font}{Type of font used in the plot. Default: \code{"serif"}.}

\item{legend_pos}{Position of legend, when a color variable is supplied. This can either be \code{"left"}, \code{"right"}, \code{"top"} or \code{"bottom"}. Default: \code{"bottom"}.}

\item{gray_scale}{If \code{TRUE}, the plot will be rendered in a gray scale. Default: \code{"TRUE"}.}

\item{res_table}{If \code{TRUE}, the function will return a data frame with observed, estimated, and residual values. Default: \code{FALSE}.}
}
\value{
A ggplot object, or, if \code{res_table = TRUE}, a data frame.
}
\description{
Function for creating plots and tables for residual values from observed and estimated values.
}
\examples{
library(forestmangr)
data("exfm11")
exfm11

# Specifying the observed and estimated variables, we get a scatter plot
# for the percentage residuals:
resid_plot(exfm11, "TH", "TH_EST1")

# It's possible to get other types of plots, with the type argument:
resid_plot(exfm11, "TH", "TH_EST1", type = "histogram_curve")
resid_plot(exfm11, "TH", "TH_EST1", type = "versus")

# It's possible to add a factor variable as color in the plots:
resid_plot(exfm11, "TH", "TH_EST1", "TH_EST2", color="STRATA", 
xlab="Total Height (m)", clab="Strata", gray_scale=FALSE)

# If there are more estimated values variables, they can also be used
# in the comparison:
resid_plot(exfm11, "TH", "TH_EST1", "TH_EST2", "TH_EST3")

# It's possible to rearrange the plots with ncol and nrow:
resid_plot(exfm11, "TH", "TH_EST1", "TH_EST2", "TH_EST3", ncol=1)

# It's possible to get the residuals table used to generate these plots, with res_table=TRUE:
head( resid_plot(exfm11, "TH", "TH_EST1", "TH_EST2", res_table = TRUE) )

}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
