% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnetar.R
\name{forecast.nnetar}
\alias{forecast.nnetar}
\title{Forecasting using neural network models}
\usage{
\method{forecast}{nnetar}(object, h = ifelse(object$m > 1, 2 * object$m, 10),
  PI = FALSE, level = c(80, 95), fan = FALSE, xreg = NULL,
  lambda = object$lambda, bootstrap = FALSE, npaths = 1000,
  innov = NULL, ...)
}
\arguments{
\item{object}{An object of class "\code{nnetar}" resulting from a call to
\code{\link{arima}}.}

\item{h}{Number of periods for forecasting. If \code{xreg} is used, \code{h}
is ignored and the number of forecast periods is set to the number of rows
of \code{xreg}.}

\item{PI}{If TRUE, prediction intervals are produced, otherwise only point
forecasts are calculated. If \code{PI} is FALSE, then \code{level},
\code{fan}, \code{bootstrap} and \code{npaths} are all ignored.}

\item{level}{Confidence level for prediction intervals.}

\item{fan}{If \code{TRUE}, level is set to \code{seq(51,99,by=3)}. This is
suitable for fan plots.}

\item{xreg}{Future values of external regressor variables.}

\item{lambda}{Box-Cox transformation parameter. Ignored if NULL. Otherwise,
forecasts back-transformed via an inverse Box-Cox transformation.}

\item{bootstrap}{If \code{TRUE}, then prediction intervals computed using
simulations with resampled residuals rather than normally distributed
errors. Ignored if \code{innov} is not \code{NULL}.}

\item{npaths}{Number of sample paths used in computing simulated prediction
intervals.}

\item{innov}{Values to use as innovations for prediction intervals. Must be
a matrix with \code{h} rows and \code{npaths} columns (vectors are coerced
into a matrix). If present, \code{bootstrap} is ignored.}

\item{...}{Additional arguments passed to \code{\link{simulate.nnetar}}}
}
\value{
An object of class "\code{forecast}".

The function \code{summary} is used to obtain and print a summary of the
results, while the function \code{plot} produces a plot of the forecasts and
prediction intervals.

The generic accessor functions \code{fitted.values} and \code{residuals}
extract useful features of the value returned by \code{forecast.nnetar}.

An object of class "\code{forecast}" is a list containing at least the
following elements: 
  \item{model}{A list containing information about the fitted model} 
  \item{method}{The name of the forecasting method as a character string} 
  \item{mean}{Point forecasts as a time series}
  \item{lower}{Lower limits for prediction intervals} 
  \item{upper}{Upper limits for prediction intervals} 
  \item{level}{The confidence values associated with the prediction intervals} 
  \item{x}{The original time series (either \code{object} itself or the time series 
           used to create the model stored as \code{object}).} 
  \item{xreg}{The external regressors used in fitting (if given).} 
  \item{residuals}{Residuals from the fitted model. That is x minus fitted values.} 
  \item{fitted}{Fitted values (one-step forecasts)}
  \item{...}{Other arguments}
}
\description{
Returns forecasts and other information for univariate neural network
models.
}
\details{
Prediction intervals are calculated through simulations and can be slow.
Note that if the network is too complex and overfits the data, the residuals
can be arbitrarily small; if used for prediction interval calculations, they
could lead to misleadingly small values.
}
\examples{
fit <- nnetar(lynx)
fcast <- forecast(fit)
plot(fcast)

}
\seealso{
\code{\link{nnetar}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
