% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focusedMDS.R
\name{focusedMDS}
\alias{focusedMDS}
\title{Focused, interactive multidimensional scaling}
\usage{
focusedMDS(distances, ids = NULL, color_cat = NULL, focus_point = ids[1],
  size = NULL, circles = 7, tol = 0.001, check_matrix = FALSE,
  subsampling = FALSE, color_palette = NULL)
}
\arguments{
\item{distances}{A square, symmetric distance matrix or 
\code{dist} object.}

\item{ids}{A vector with length equal to the 
number of rows of the matrix given in \code{distances}.
Must be a character vector.}

\item{color_cat}{A vector with length equal to the
number of rows of the matrix given in \code{distances}.
Content of the vector can be either numeric, factor, or 
character. Values will be assigned to color categories.}

\item{focus_point}{The initial ID to be plotted at the
center of the focusedMDS graph (default is the first 
element in the \code{ids} vector). Must be an element of
the \code{ids} vector.}

\item{size}{The fixed size of the focusedMDS graph, in 
pixels. Disables dynamic sizing.}

\item{circles}{The number of background polar gridlines.}

\item{tol}{The tolerance for the optimization method choosing
the location of the non-focus points. Default 0.001.}

\item{check_matrix}{Logical value permitting additional checks of the matrix,
ensuring that the given matrix fulfills the
triangle inequality. Slows down the initial graph plotting, 
but useful if you are not sure if your matrix is a distance
matrix or has been calculated correctly.}

\item{subsampling}{Logical value stating that for samples of over
100 points, each point iteratively plotted after the 100th point will 
be optimized to a subsample of the previously plotted data points.
Recommended for plotting data sets with more than 300 points.}

\item{color_palette}{Optional specification of a color palette to use
when \code{colors} parameter is given. Must be a vector of CSS colors, 
with length at least as long as the number of unique variables in
\code{colors}.}
}
\description{
\code{focusedMDS} takes a distance matrix and plots
it as an interactive graph. Double click on
any point to choose a new focus point, and hover over
points to see their ID labels. In this graph, one point 
is focused on at the center of the graph. All other points
are plotted around this central point at their exact 
distances to the point, as given in the distance matrix.
In other words, the distance between each point and the
focus point are the true distances given in the distance 
matrix. The non focus points are plotted with respect to 
each other as exactly as possible. For more details, see
\url{https://lea-urpa.github.io/focusedMDS.html}.
}
\examples{
# See http://lea-urpa.github.io/focusedMDS.html for 
# an illustrated version of this example.

library(datasets)
library(focusedMDS)

# Load Edgar Anderson's Iris Data
data("iris")

# Create table of measures to compare individuals on
table <- iris[ , c("Petal.Length", "Petal.Width", "Sepal.Length", "Sepal.Width")]

# Find euclidean distances based on these measures
dists <- dist(table)

# Simplest usage: only with dataset
focusedMDS(dists)

# Create labels based on flower species
colorvector <- as.vector(iris$Species)

colors <- c("firebrick", "cornflowerblue", "gold")

# Visualization with color labels
focusedMDS(dists, color_cat = colorvector, color_palette = colors )

# Create text labels
table(iris$Species)
names <- c(paste(rep("setosa", 50), 1:50, sep=""),
           paste(rep("versicolor", 50), 1:50, sep=""),
           paste(rep("virginica", 50), 1:50, sep=""))

focusedMDS(dists, ids = names, color_cat = colorvector, color_palette = colors)



}

