% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastmdu.R
\name{fastmdu}
\alias{fastmdu}
\title{(Restricted) Multidimensional Unfolding Function}
\usage{
fastmdu(
  delta,
  w = NULL,
  p = 2,
  x = NULL,
  rx = NULL,
  y = NULL,
  ry = NULL,
  MAXITER = 1024,
  FCRIT = 1e-08,
  error.check = FALSE,
  echo = FALSE
)
}
\arguments{
\item{delta}{an n by m rectangular matrix containing dissimilarities.}

\item{w}{an identical sized matrix containing nonnegative weights (all ones when omitted).}

\item{p}{dimensionality (default = 2).}

\item{x}{either initial or fixed row coordinates (n by p) or independent row variables (n by hx).}

\item{rx}{Row restriction. If omitted, x is free and x contains the initial row coordinates.
If logical valued, x (n by p) contains the initial row coordinates and rx (n by p) indicates free (false) and fixed (true) row coordinates.
If real valued, x (n by hx) contains hx independent row variables and rx (hx by p) contains the initial row regression coefficients.}

\item{y}{either initial or fixed column coordinates (m by p) or independent column variables (n by hy).}

\item{ry}{Column restriction. If omitted, y is free and y contains the initial column coordinates.
If logical valued, y (m by p) contains the initial column coordinates and ry (m by p) indicated free (false) and fixed (true) column coordinates.
If real valued, y (n by hy) contains hy independent column variables and ry (hy by p) contains the initial column regression coefficients.}

\item{MAXITER}{maximum number of iterations (default = 1024).}

\item{FCRIT}{relative convergence criterion (default = 0.00000001).}

\item{error.check}{extensive check validity input parameters (default = FALSE).}

\item{echo}{print intermediate algorithm results (default = FALSE).}
}
\value{
data original n by m matrix with dissimilarities.

weights original n by m matrix with dissimilarity weights.

row.coordinates final n by p matrix with row coordinates.

col.coordinates final m by p matrix with column coordinates.

row.coefficients if rx is real valued, final hx by p matrix with row regression coefficients.

col.coefficients if ry is real valued, final hy by p matrix with column regression coefficients.

distances final n by m matrix with distances.

last.iteration final iteration number.

last.difference final function difference used for convergence testing.

n.stress final normalized stress value.

stress.1 final stress-1 value.

call function call
}
\description{
\code{fastmdu} performs three types of multidimensional unfolding in different combination for row and column objects.
The function follows algorithms given by de Leeuw and Heiser (1980), Heiser (1987), and Busing (2010).
}
\examples{
\dontrun{
library( smacof )
data( "breakfast" )
breakfast <- as.matrix( breakfast )
n <- nrow( breakfast )
m <- ncol( breakfast )
p <- 2
w <- matrix( 1, n, m )
x <- matrix( runif( n * p ), n, p )
y <- matrix( runif( m * p ), m, p )
r <- fastmdu( breakfast, w, p, x, NULL, y, NULL )
print( r )
}
}
\references{
de Leeuw, J., and Heiser, W. J. (1980). Multidimensional scaling with restrictions on the configuration.
            In P.R. Krishnaiah (Ed.), Multivariate analysis (Vol. 5, pp. 501–522).
            Amsterdam, The Netherlands: North-Holland Publishing Company.

            Heiser,W. J. (1987a). Joint ordination of species and sites: The unfolding technique.
            In P. Legendre and L. Legendre (Eds.), Developments in numerical ecology (pp. 189–221).
            Berlin, Heidelberg: Springer-Verlag.

            Busing, F.M.T.A. (2010). Advances in multidimensional unfolding.
            Unpublished doctoral dissertation, Leiden University, Leiden, the Netherlands.
}
