% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/petersen.R
\name{petersen}
\alias{petersen}
\title{Mark-Recapture Population Size Estimator}
\usage{
petersen(first, second)
}
\arguments{
\item{first}{vector with first sample identifiers (local minima)}

\item{second}{vector with second sample identifiers (local minima)}
}
\value{
population size estimate
}
\description{
\code{petersen} returns the estimated population size based on two independent equally-sized samples
}
\examples{
seed <- 1041245
set.seed( seed )
population <- c( rep( 1:200, 10 ), rep( 201:400, 40 ) )
length( population )
length( unique( population ) )
s1 <- sample( population, 500 )
s2 <- sample( population, 500 )
Nhat <- petersen( s1, s2 )
print( Nhat )

}
\references{
Busing (2025).
            A Simple Population Size Estimator for Local Minima Applied to Multidimensional Scaling.
}
\author{
Frank M.T.A. Busing
}
