% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices-class.R
\name{iborindices}
\alias{iborindices}
\alias{AUDBBSW}
\alias{EURIBOR}
\alias{GBPLIBOR}
\alias{JPYLIBOR}
\alias{JPYTIBOR}
\alias{NZDBKBM}
\alias{USDLIBOR}
\alias{CHFLIBOR}
\alias{HKDHIBOR}
\alias{NOKNIBOR}
\alias{AUDBBSW}
\alias{AUDBBSW1b}
\alias{EURIBOR}
\alias{GBPLIBOR}
\alias{JPYLIBOR}
\alias{JPYTIBOR}
\alias{NZDBKBM}
\alias{USDLIBOR}
\alias{CHFLIBOR}
\alias{HKDHIBOR}
\alias{NOKNIBOR}
\title{Standard IBOR}
\usage{
AUDBBSW(tenor)

AUDBBSW1b(tenor)

EURIBOR(tenor)

GBPLIBOR(tenor)

JPYLIBOR(tenor)

JPYTIBOR(tenor)

NZDBKBM(tenor)

USDLIBOR(tenor)

CHFLIBOR(tenor)

HKDHIBOR(tenor)

NOKNIBOR(tenor)
}
\arguments{
\item{tenor}{the tenor of the IBOR index (e.g. \code{months(3)})}
}
\description{
These functions create commonly used IBOR indices with standard market
conventions.
}
\details{
The key conventions are tabulated below.

\tabular{llllll}{
\bold{Creator} \tab \bold{Spot lag (days)} \tab \bold{Fixing calendars} \tab
\bold{Day basis} \tab \bold{Day convention} \tab \bold{EOM} \cr
AUDBBSW() \tab 0 \tab AUSYCalendar \tab act/365 \tab ms \tab FALSE \cr
EURIBOR() \tab 2 \tab EUTACalendar \tab act/360 \tab mf \tab TRUE \cr
GBPLIBOR() \tab 0 \tab GBLOCalendar \tab act/365 \tab mf \tab TRUE \cr
JPYLIBOR() \tab 2 \tab GBLOCalendar \tab act/360 \tab mf \tab TRUE \cr
JPYTIBOR() \tab 2 \tab JPTOCalendar \tab act/365 \tab mf \tab FALSE \cr
NZDBKBM() \tab 0 \tab NZWECalendar, NZAUCalendar \tab act/365 \tab mf \tab FALSE \cr
USDLIBOR() \tab 2 \tab USNYCalendar, GBLOCalendar \tab act/360 \tab mf \tab TRUE \cr
CHFLIBOR() \tab 2 \tab GBLOCalendar \tab act/360 \tab mf \tab TRUE \cr
HKDHIBOR() \tab 0 \tab HKHKCalendar \tab act/365 \tab mf \tab FALSE \cr
NOKNIBOR() \tab 2 \tab NOOSCalendar \tab act/360 \tab mf \tab FALSE
}

There are some nuances to this. Sub-1m LIBOR and TIBOR spot lags are zero
days (excepting spot-next rates) and use the following day convention and the
overnight USDLIBOR index uses both USNYCalendar and GBLOCalendar calendars.
}
\references{
\href{http://www.asx.com.au/documents/products/bbsw-conventions.pdf}{BBSW}
\href{http://www.emmi-benchmarks.eu/assets/files/Euribor_tech_features.pdf}{EURIBOR}
\href{https://www.theice.com/iba/libor}{ICE LIBOR}
\href{http://www.bbalibor.com/technical-aspects/fixing-value-and-maturity}{BBA LIBOR}
\href{http://www.jbatibor.or.jp/english/public/pdf/JBA\%20TIBOR\%20Operational\%20RulesE.pdf}{TIBOR}
\href{http://www.nzfma.org/includes/download.aspx?ID=130053}{NZD BKBM}
\href{http://opnga.ma/conventions}{OpenGamma Interest Rate Instruments and Market Conventions Guide}
\href{https://bank.hangseng.com/1/2/rates/hibor}{HKD HIBOR}
}
\seealso{
Other constructors: \code{\link{CurrencyConstructors}},
  \code{\link{CurrencyPairConstructors}},
  \code{\link{oniaindices}}
}
