% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/flows.R
\name{firstflowsg}
\alias{firstflowsg}
\title{Flow Selection Based on Global Criteria}
\usage{
firstflowsg(mat, method = "nfirst", k, ties.method = "first")
}
\arguments{
\item{mat}{A square matrix of flows.}

\item{method}{A method of flow selection, one of "nfirst", "xfirst" or "xsumfirst":
\itemize{
\item{nfirst selects the k first flows of the matrix,}
\item{xfirst selects flows greater than k,}
\item{xsumfirst selects as many flows as necessary so that their sum is at least equal to k.}
}}

\item{k}{Selection threshold.}

\item{ties.method}{In case of equality with "nfirst" method, use "random" or "first" (see \link{rank}).}
}
\value{
A boolean matrix of selected flows.
}
\description{
Flow selection based on global criteria.
}
\details{
As the output is a boolean matrix, use element-wise multiplication to get flows intensity.
}
\examples{
# Import data
data(nav)
myflows <- prepflows(mat = nav, i = "i", j = "j", fij = "fij")

# Remove the matrix diagonal
diag(myflows) <- 0

# Select the 50 first flows of the matrix
flowSel <- firstflowsg(mat = myflows, method = "nfirst", ties.method = "first",
                       k = 50)
statmat(mat = myflows * flowSel, output = "none")

# Select all flows greater than 2000
flowSel <- firstflowsg(myflows, method = "xfirst", k= 2000)
statmat(mat = myflows * flowSel, output = "none")

# Select flows that represent at least 50\% of the matrix flows
k50 <- sum(myflows)/2
flowSel <- firstflowsg(mat = myflows, method = "xsumfirst", k = 150000)
statmat(mat = myflows * flowSel, output = "none")
}
\seealso{
\link{firstflows}, \link{domflows}
}

