% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class-def.R
\docType{class}
\name{queue-class}
\alias{queue}
\alias{queue-class}
\title{A \code{queue} object defines details regarding how a job is submitted}
\usage{
queue(object, platform = c("local", "lsf", "torque", "sge", "moab"),
  format = "", queue = "long", walltime, memory, cpu = 1,
  extra_opts = "", submit_exe, nodes = "1", jobname = "name",
  email = Sys.getenv("USER"), dependency = list(), server = "localhost",
  verbose = FALSE, cwd = "", stderr = "", stdout = "", ...)
}
\arguments{
\item{object}{this is not used currenlty, ignore.}

\item{platform}{Required and important. Currently supported values are 'lsf' and 'torque'. [Used by class job]}

\item{format}{[advanced use] We have a default format for the final command line string generated for 'lsf' and 'torque'.}

\item{queue}{the type of queue your group usually uses
'bsub' etc.}

\item{walltime}{max walltime of a job.}

\item{memory}{The amount of memory reserved. Units depend on the platform used to process jobs}

\item{cpu}{number of cpus you would like to reserve [Used by class job]}

\item{extra_opts}{[advanced use] Extra options to be supplied while create the job submission string.}

\item{submit_exe}{[advanced use] Already defined by 'platform'. The exact command used to submit jobs to the cluster example 'qsub'}

\item{nodes}{[advanced use] number of nodes you would like to request. Or in case of torque name of the nodes.\emph{optional} [Used by class job]}

\item{jobname}{[debug use] name of this job in the computing cluster}

\item{email}{[advanced use] Defaults to system user, you may put you own email though may get tons of them.}

\item{dependency}{[debug use] a list of jobs to complete before starting this one}

\item{server}{[not used] This is not implemented currently. This would specify the head node of the computing cluster. At this time submission needs to be done on the head node of the cluster where flow is to be submitted}

\item{verbose}{[logical] TRUE/FALSE}

\item{cwd}{[debug use] Ignore}

\item{stderr}{[debug use] Ignore}

\item{stdout}{[debug use] Ignore}

\item{...}{other passed onto object creation. Example: memory, walltime, cpu}
}
\description{
Internal function (used by \link{to_flow}), to define the format used to submit a job.
}
\details{
\strong{Resources}:
Can be defined **once** using a \link{queue} object and recylced to all the jobs in a flow. If resources (like memory, cpu, walltime, queue) are supplied at the
job level they overwrite the one supplied in \link{queue}
Nodes: can be supplied ot extend a job across multiple nodes. This is purely experimental and not supported.

\strong{Server}:
This a hook which may be implemented in future.

\strong{Submission script}
The 'platform' variable defines the format, and submit_exe; however these two are avaible for someone to create a custom submission command.
}
\examples{
qobj <- queue(platform='lsf')
}
\keyword{queue}

