% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_unknown_mods.R
\name{analyze_unknown_mods}
\alias{analyze_unknown_mods}
\title{Analysis of unknown modifications}
\usage{
analyze_unknown_mods(
  input_df,
  level = c("precursor, modified_peptides"),
  plot = TRUE,
  plot_characteristic = c("absolute", "relative")
)
}
\arguments{
\item{input_df}{A tibble with the traceR_precursor_unknownMods or traceR_mod.peptides_unknownMods column.}

\item{level}{Choose either \code{precursor} for traceR_precursor_unknownMods or \code{modified_peptides} for traceR_mod.peptides_unknownMods. Default is precursor.}

\item{plot}{Logical value, default is TRUE. If \code{TRUE} barplot is generated, if \code{FALSE} report as output.}

\item{plot_characteristic}{If \code{absolute} the absolute count is displayed in barplot, if \code{relative} the relative count is displayed in barplot. Default is absolute. \code{plot_characteristic} has no influence on report.}
}
\value{
This function returns a plot - absolute/relative counts - or a data frame.
}
\description{
Analysis of the traceR_precursor_unknownMods or traceR_mod.peptides_unknownMods column
}
\details{
Shows the absolute and relative counts of TRUE/FALSE of the traceR_precursor_unknownMods or traceR_mod.peptides_unknownMods column - as data frame or plot. Duplicate traceR_mod.peptides entries or traceR_precursor entries are removed, respectively.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(ggplot2)
library(tibble)

# Generate data
data <- tibble::tibble(
 "traceR_mod.peptides" = c("AACLLPK",
  "ALTDM(UniMod:35)PQM(UniMod:35)R",
  "ALTDM(DummyModification)PQMK",
  "ALTDM(UniMod:35)PQM(UniMod:35)R",
  "ALTDM(DummyModification)PQMK"),
 "traceR_mod.peptides_unknownMods" = c(FALSE, FALSE, TRUE, FALSE, TRUE),
 "traceR_precursor" = c("AACLLPK2",
  "ALTDM(UniMod:35)PQM(UniMod:35)R2",
  "ALTDM(DummyModification)PQMK3",
  "ALTDM(UniMod:35)PQM(UniMod:35)R2",
  "ALTDM(DummyModification)PQMK3"),
 "traceR_precursor_unknownMods" = c(FALSE, FALSE, TRUE, FALSE, TRUE)
)

# Generate Report - precursor level
analyze_unknown_mods(
 input_df = data,
 level = "precursor",
 plot = FALSE
)

# Generate relative Plot - peptide level
analyze_unknown_mods(
 input_df = data,
 level = "modified_peptides",
 plot = TRUE,
 plot_characteristic = "relative"
)
}
\author{
Oliver Kardell
}
