% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flob.R
\name{unflob}
\alias{unflob}
\title{Unflob to File}
\usage{
unflob(flob, dir = ".", name = "", ext = "")
}
\arguments{
\item{flob}{The \code{\link[=flob]{flob()}} to save to file.}

\item{dir}{A string of the path to the directory to save the file in.}

\item{name}{A string of the name (without the extension) for the file.
If "" (the default) then the original file name is used.}

\item{ext}{A string of the extension for the file.
If "" (the default) then the original extension is used.}
}
\value{
An invisible string of the path to the saved file.
}
\description{
Converts a \code{\link[=flob]{flob()}} back to its original file format.
}
\details{
If path ends with a file separator then the name and extension
of the flob is added.
If the flob is an older flob that was not saved with a name then
it is named 'file'.

If path ends with a file name without an extension then the
extension of the flob
is automatically added.
Alternatively if path also includes an extension
then it must match the flob's extension.
}
\examples{
unflob(flob_obj, tempdir())
}
