% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{flimoptim}
\alias{flimoptim}
\title{flimoptim}
\usage{
flimoptim(
  ndraw,
  data = NULL,
  dsumstats = NULL,
  simulatorQ = NULL,
  obj = NULL,
  nsim = 10,
  ninfer = 1,
  lower = 0,
  upper = 1,
  Theta0 = (lower + upper)/2,
  randomTheta0 = FALSE,
  mode = c("R", "Julia"),
  AD = TRUE,
  method = "",
  obj_threshold = Inf,
  number_tries = 1,
  maxit = 1000,
  time_limit = NaN,
  factr = 1e+07,
  pgtol = 0,
  xtol = 0,
  ftol = 0,
  gtol = 1e-08,
  reltol = sqrt(.Machine$double.eps),
  abstol = .Machine$double.eps,
  show_trace = FALSE,
  store_trace = FALSE,
  store_quantiles = FALSE,
  par_names = NULL,
  load_julia = FALSE
)
}
\arguments{
\item{ndraw}{Integer. Number of random variables to draw
for one simulation of the model.}

\item{data}{1D array containing the observations.}

\item{dsumstats}{Summary statistics to measure distance
between simulations and data.
In R mode : R function of type dsumstats(simulations, data)
where simulations : 2D array and data : 1D array.
ncol(simulations) = length(data) mandatory.
In Julia mode : a string containing the script of the Julia function
dsumstats(simulations, data). The name "dsumstats" is mandatory.}

\item{simulatorQ}{Simulator of the stochastic process with fixed quantiles
(see README).
or a string (in mode "Julia") containing the script of the Julia function
simulatorQ(Theta, quantiles).
In Julia mode, the name "simulatorQ" is mandatory.
Theta is the parameter set for the simulations and
quantiles are drawn in U(0,1).}

\item{obj}{Objective function to minimize.
Default : is directly computed from dsumstats and simulatorQ.
Either an R function of type objective(Theta, quantiles) (in mode "R")
or a string (in mode "Julia") containing the script of the Julia function
julia_obj(Theta, quantiles).
Warning : could be tricky if mode = "Julia" to call data.
In Julia mode, the name "julia_obj" is mandatory.}

\item{nsim}{Integer. Number of simulations to run for each step
of the optimization algorithm.
Computation time grows linearly with this number. Default to 10.}

\item{ninfer}{Integer. Number of independent inferences to run. Default to 1.}

\item{lower}{1D array. Lower bounds for parameters. Same length as upper.
With Nelder-Mead in Julia mode: only used for starting point.}

\item{upper}{1D array. Upper bounds for parameters. Same length as lower.
With Nelder-Mead in Julia mode: only used for starting point.}

\item{Theta0}{1D array. Initial values of the parameters.
Default : mean(lower, upper).}

\item{randomTheta0}{Boolean.
If True, Theta0 is randomly drawn between lower and upper bounds.}

\item{mode}{String. "R" (default) or "Julia". See README.}

\item{AD}{Boolean.
Only in Julia mode, uses Automatic Differentiation with IPNewton method.
Default to true.}

\item{method}{String.
In Julia mode, allows to choose the optimization method :
"IPNewton", "Brent" or "NelderMead". Default : IPNewton.}

\item{obj_threshold}{Float. Threshold score. If Final value of objective is
bigger, relaunch the inference if number_tries is not reached.
The purpose is to avoid local minima. Default to Inf (no threshold).}

\item{number_tries}{Integer. Number of tries (inferences) for the objective
value to reach a point lower than obj_threshold. Default to 1.}

\item{maxit}{Integer. Max number of iterations during optimization.
Default to 1000.}

\item{time_limit}{Float. Time limit in second for each inference.
Default to no limit. Not available for R mode and Brent method in Julia mode.}

\item{factr}{Float.
In R-mode : control parameter for L-BFGS-B method in stats::optim.
Default to 1e7.}

\item{pgtol}{Float.
In R-mode : control parameter for L-BFGS-B method in stats::optim.
Default to 0.}

\item{xtol}{Float.
In Julia mode with IPNewton method : xtol option in Optim.Options.
Default to 0.}

\item{ftol}{Float.
In Julia mode with IPNewton method : ftol option in Optim.Options.}

\item{gtol}{Float.
In Julia mode with IPNewton method : gtol option in Optim.Options.
Default to 1e-8.}

\item{reltol}{Float.
In Julia mode with Brent method : reltol of Optim.optimize.
Default is sqrt(.Machine$double.eps), about 1e-8.}

\item{abstol}{Float.
In Julia mode with Brent method : abstol of Optim.optimize.
Default is .Machine$double.eps, about 1e-16.}

\item{show_trace}{Boolean. If true, shows standard trace. Default to false.}

\item{store_trace}{Boolean.
If true, stores standard trace as an array of strings.
Default to false. Not available for R mode.}

\item{store_quantiles}{Boolean.
If true, stores every quantiles used for inference, to reproduce the results.
Default to false.}

\item{par_names}{vector of names for parameters.
Default is "par1", ..., "parn".}

\item{load_julia}{Boolean. If true, run julia_load.
It can take few seconds. Default to False.}
}
\value{
Object of class flimo_result (list)
(converted from Julia object in Julia mode) containing every information
about convergence results.
}
\description{
Computes several parameter inferences with R optimizer or
Julia optimizer in a full Julia mode.
In R mode (default) : L-BFGS-B optimization.
In Julia mode : either IPNewton with or without Automatic Differentiation,
Nelder-Mead or Brent optimization.
Argument ndraw is mandatory.
You need either to provide data, dsumstats AND simulatorQ
OR obj.
}
\examples{
data <- rep(100, 5)

simulatorQ <- function(Theta, quantiles){
qpois(quantiles, lambda = Theta)
}
dsumstats <- function(simulations, data){
mean_simu <- mean(rowMeans(simulations))
mean_data <- mean(data)
(mean_simu-mean_data)^2
}

flimoptim(5, data, dsumstats, simulatorQ,
lower = 50,
upper = 150)

}
