% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_objective}
\alias{plot_objective}
\title{plot_objective}
\usage{
plot_objective(
  ndraw,
  nsim,
  data,
  sumstats,
  simulatorQ,
  quantiles = NULL,
  obj = NULL,
  index = NULL,
  other_param = NULL,
  lower = 0,
  upper = 1,
  dim2 = TRUE,
  visualize_min = TRUE,
  plot_legend = TRUE,
  add_to_plot = NULL
)
}
\arguments{
\item{ndraw}{Integer.Number of random variables to draw
for one simulation of the model.}

\item{nsim}{Integer. Number of simulations to run for each step
of the optimization algorithm.
Computation time grows linearly with this number. Default to 10.}

\item{data}{1D array containing the observations.}

\item{sumstats}{Function computing the distance
between simulations and data of form sumstats(simulations, data)
where simulations : 2D array and data : 1D array.
ncol(simulations) = length(data) mandatory.}

\item{simulatorQ}{Function of type simulatorQ(Theta, quantiles)
where Theta is the parameter set for the simulations and
quantiles are drawn in U(0,1).}

\item{quantiles}{2D array containing values following U(0,1).
Row number = number of simulations.
Column number = number of random variables to draw in one simulation.}

\item{obj}{objective function of type objective(Theta).
Default : directly computed with "sumstats" and "simulatorQ".}

\item{index}{Integer. Index of the moving parameter.}

\item{other_param}{Other parameters of the model. If NULL : assume 1D-model.
If numeric : 2D-model, one curve.
If 1D-array and dim2 is True (default) :
2D-model, one curve by value in other_param.
If 1D-array and dim2 is False or 2D-array : (n>2)D-model,
one curve by row in other_param.
If your model has n>2 dimensions,
you should define other_param as a matrix even if
you have only one parameter set to test
(with as.matrix(t(vect_param)) where vect_param is a 1D-array).}

\item{lower}{Numeric. Lower value of the plot.}

\item{upper}{Numeric. Upper value of the plot.}

\item{dim2}{Boolean. True if model is 2-dimensional.}

\item{visualize_min}{Boolean. If True, show explicitly the minimum point.}

\item{plot_legend}{Boolean. If True (default), plots the legend.}

\item{add_to_plot}{ggplot object. If not NULL,
will add all curves/points on previous plot instead of creating a new one.
Does not change title/labels/limits defined in previous plot.}
}
\value{
ggplot object representing the objective function to be minimized.
}
\description{
Plot of objective = f(theta_index).
}
\examples{
data <- rep(100, 5)

sumstats <- function(simulations, data){
mean_simu <- mean(rowMeans(simulations))
mean_data <- mean(data)
(mean_simu-mean_data)^2
}

simulatorQ <- function(Theta, quantiles){
qpois(quantiles, lambda = Theta)
}

plot_objective(5, 10, data, sumstats, simulatorQ, lower = 0, upper = 200)

}
