% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_footer_lines}
\alias{add_footer_lines}
\title{Add labels as new rows in the footer}
\usage{
add_footer_lines(x, values = character(0), top = FALSE)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{values}{a character vector, each element will
be added as a new row.}

\item{top}{should the row be inserted at the top
or the bottom. Default to TRUE.}
}
\description{
Add labels as new rows in the footer,
where all columns are merged.

This is a sugar function to be used when you need to
add labels in the footer, a footnote for example.
}
\section{Illustrations}{

\if{html}{\figure{fig_add_footer_lines_1.png}{options: width="300"}}
}

\examples{
ft_1 <- flextable(head(iris))
ft_1 <- add_footer_lines(ft_1,
  values = c("blah 1", "blah 2")
)
ft_1
}
\seealso{
Other functions that add lines in the table: 
\code{\link{add_body_row}()},
\code{\link{add_body}()},
\code{\link{add_footer_row}()},
\code{\link{add_footer}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()}

Other functions to add rows in header or footer: 
\code{\link{add_footer_row}()},
\code{\link{add_footer}()},
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions that add lines in the table}
\concept{functions to add rows in header or footer}
