% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_header_lines}
\alias{add_header_lines}
\title{Add labels as new rows in the header}
\usage{
add_header_lines(x, values = character(0), top = TRUE)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{values}{a character vector, each element will
be added as a new row.}

\item{top}{should the row be inserted at the top
or the bottom. Default to TRUE.}
}
\description{
Add labels as new rows in the header,
where all columns are merged.

This is a sugar function to be used when you need to
add labels in the header, most of the time it will
be used to adding titles on the top rows of the flextable.
}
\section{Illustrations}{

\if{html}{\figure{fig_add_header_lines_1.png}{options: width="300"}}
}

\examples{
ft_1 <- flextable(head(iris))
ft_1 <- add_header_lines(ft_1, values = "blah blah")
ft_1 <- add_header_lines(ft_1, values = c("blah 1", "blah 2"))
ft_1 <- autofit(ft_1)
ft_1
}
\seealso{
Other functions to add rows in header or footer: 
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_footer}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions that add rows in the table}
\concept{functions to add rows in header or footer}
