% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstate.R
\name{pmatrix.fs}
\alias{pmatrix.fs}
\title{Transition probability matrix from a fully-parametric, time-inhomogeneous
Markov multi-state model}
\usage{
pmatrix.fs(x, trans, t = 1, newdata = NULL, ci = FALSE, tvar = "trans",
  sing.inf = 1e+10, B = 1000, cl = 0.95, ...)
}
\arguments{
\item{x}{A model fitted with \code{\link{flexsurvreg}}.  See
\code{\link{msfit.flexsurvreg}} for the required form of the model and the
data.  Additionally, this must be a Markov / clock-forward model, but can
be time-inhomogeneous.  See the package vignette for further explanation.

\code{x} can also be a list of models, with one component for each
permitted transition, as illustrated in \code{\link{msfit.flexsurvreg}}.}

\item{trans}{Matrix indicating allowed transitions.  See
\code{\link{msfit.flexsurvreg}}.}

\item{t}{Time or vector of times to predict state occupancy probabilities
for.}

\item{newdata}{A data frame specifying the values of covariates in the
fitted model, other than the transition number.  See
\code{\link{msfit.flexsurvreg}}.}

\item{ci}{Return a confidence interval calculated by simulating from the
asymptotic normal distribution of the maximum likelihood estimates.  Turned
off by default, since this is computationally intensive.  If turned on,
users should increase \code{B} until the results reach the desired
precision.}

\item{tvar}{Variable in the data representing the transition type. Not
required if \code{x} is a list of models.}

\item{sing.inf}{If there is a singularity in the observed hazard, for
example a Weibull distribution with \code{shape < 1} has infinite hazard at
\code{t=0}, then as a workaround, the hazard is assumed to be a large
finite number, \code{sing.inf}, at this time.  The results should not be
sensitive to the exact value assumed, but users should make sure by
adjusting this parameter in these cases.}

\item{B}{Number of simulations from the normal asymptotic distribution used
to calculate variances.  Decrease for greater speed at the expense of
accuracy.}

\item{cl}{Width of symmetric confidence intervals, relative to 1.}

\item{...}{Arguments passed to \code{\link{ode}} in \pkg{deSolve}.}
}
\value{
The transition probability matrix, if \code{t} is of length 1, or a
list of matrices if \code{t} is longer.

If \code{ci=TRUE}, each element has attributes \code{"lower"} and
\code{"upper"} giving matrices of the corresponding confidence limits.
These are formatted for printing but may be extracted using \code{attr()}.
}
\description{
The transition probability matrix for time-inhomogeneous Markov multi-state
models fitted to time-to-event data with \code{\link{flexsurvreg}}.  This
has \eqn{r,s} entry giving the probability that an individual is in state
\eqn{s} at time \eqn{t}, given they are in state \eqn{r} at time \eqn{0}.
}
\details{
This is computed by solving the Kolmogorov forward differential equation
numerically, using the methods in the \code{\link{deSolve}} package.  The
equation is

\deqn{\frac{dP(t)}{dt} = P(t) Q(t)}

where \eqn{P(t)} is the transition probability matrix for time \eqn{t}, and
\eqn{Q(t)} is the transition hazard or intensity as a function of \eqn{t}.
The initial condition is \eqn{P(0) = I}.

Note that the package \pkg{msm} has a similar method \code{pmatrix.msm}.
\code{pmatrix.fs} should give the same results as \code{pmatrix.msm} when
both of these conditions hold:

\itemize{ \item the time-to-event distribution is exponential for all
transitions, thus the \code{flexsurvreg} model was fitted with
\code{dist="exp"} and the model is time-homogeneous.  \item the \pkg{msm}
model was fitted with \code{exacttimes=TRUE}, thus all the event times are
known, and there are no time-dependent covariates.  }

\pkg{msm} only allows exponential or piecewise-exponential time-to-event
distributions, while \pkg{flexsurvreg} allows more flexible models.
\pkg{msm} however was designed in particular for panel data, where the
process is observed only at arbitrary times, thus the times of transition
are unknown, which makes flexible models difficult.

This function is only valid for Markov ("clock-forward") multi-state
models, though no warning or error is currently given if the model is not
Markov.  See \code{\link{pmatrix.simfs}} for the equivalent for semi-Markov
("clock-reset") models.
}
\examples{

# BOS example in vignette, and in msfit.flexsurvreg
bexp <- flexsurvreg(Surv(Tstart, Tstop, status) ~ trans,
                    data=bosms3, dist="exp")
tmat <- rbind(c(NA,1,2),c(NA,NA,3),c(NA,NA,NA))
# more likely to be dead (state 3) as time moves on, or if start with
# BOS (state 2)
pmatrix.fs(bexp, t=c(5,10), trans=tmat)
}
\seealso{
\code{\link{pmatrix.simfs}}, \code{\link{totlos.fs}},
\code{\link{msfit.flexsurvreg}}.
}
\author{
Christopher Jackson \email{chris.jackson@mrc-bsu.cam.ac.uk}.
}
\keyword{models,survival}
