% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_comparison.R
\name{goodness_of_fit}
\alias{goodness_of_fit}
\alias{AIC.modeler}
\alias{BIC.modeler}
\title{Akaike's An Information Criterion for an object of class \code{modeler}}
\usage{
\method{AIC}{modeler}(object, ..., k = 2)

\method{BIC}{modeler}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{modeler} resulting of
executing the function \code{modeler()}}

\item{...}{Further parameters. For future improvements.}

\item{k}{Numeric, the penalty per parameter to be used; the default k = 2 is
the classical AIC.}
}
\value{
A \code{tibble} with columns giving the corresponding AIC and BIC.
}
\description{
Generic function calculating Akaike's ‘An Information Criterion’
for fitted model object of class \code{modeler}.
}
\examples{
library(flexFitR)
dt <- data.frame(X = 1:6, Y = c(12, 16, 44, 50, 95, 100))
mo_1 <- modeler(dt, X, Y, fn = "fn_lin", param = c(m = 10, b = -5))
mo_2 <- modeler(dt, X, Y, fn = "fn_quad", param = c(a = 1, b = 10, c = 5))
AIC(mo_1)
AIC(mo_2)
BIC(mo_1)
BIC(mo_2)
}
\author{
Johan Aparicio [aut]
}
