% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getUniqueElements}
\alias{fxml_getUniqueElements}
\title{Handling flat XML files}
\usage{
fxml_getUniqueElements(xmlflat.df)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}
}
\value{
A vector with all the names of the elements included in the XML document \code{xmlflat.df}. Every tag is only returned once, even if it occurs multiple times in the document. The return vector is empty (\code{NULL}) if no elements exist.
}
\description{
Returns the unique XML elements included in an XML document.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Identify the unique XML elements
fxml_getUniqueElements(xml.dataframe)
}
\seealso{
\code{\link{fxml_getElement}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
