% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table_replace_dec.R
\name{replace_dec}
\alias{replace_dec}
\alias{replace_dec.pivot_table}
\title{Replace decimal separator}
\usage{
replace_dec(pt, sep = ".")

\method{replace_dec}{pivot_table}(pt, sep = ".")
}
\arguments{
\item{pt}{A pivot_table object.}

\item{sep}{A character, new decimal separator to use.}
}
\value{
A pivot_table object.
}
\description{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data. Values, even though they are numbers, are
represented as text and sometimes include a decimal separator different from
the one needed; it can be replaced using this function.
}
\details{
To correctly carry out this operation, the number of rows and columns that
contain labels must be defined, and the table must only contain the pivot
table rows and columns.

The only decimal separators considered are "." and ",".
}
\examples{
library(tidyr)

pt <-
  pt_m4 \%>\%
  remove_top(1) \%>\%
  define_labels(n_col = 2, n_row = 2) \%>\%
  replace_dec()

}
\keyword{internal}
