% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{flatness_indices}
\alias{flatness_indices}
\title{Compute flatness indices for (rank) histograms}
\usage{
flatness_indices(rkhists, ...)
}
\arguments{
\item{rkhists}{an object containing (rank) histograms}

\item{...}{other arguments}
}
\value{
the expected returned object is a matrix, with one flatness index in
each column for each rank histogram (row-wise). The columns should be named,
with "chisq" for the chi-square statistics, "RI" for the reliability index
and "entropy" for the entropy.
}
\description{
S3 generic function that computes and returns indices of flatness of one or
several (rank) histograms, presented in Wilks (2019).
}
\details{
Currently the implemented flatness indices are the chi-square statistics, the
reliability index and the entropy.
}
\references{
Wilks, D. S. "Indices of rank histogram flatness and their sampling
properties." \emph{Monthly Weather Review} 147.2 (2019): 763-769.
doi:https://doi.org/10.1175/MWR-D-18-0369.1
}
