% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_weighted_mean.R
\name{grouped_weighted_mean}
\alias{grouped_weighted_mean}
\title{Fast Grouped Weighted Mean}
\usage{
grouped_weighted_mean(
  data,
  x,
  w = NULL,
  by = NULL,
  na.rm = TRUE,
  value_name = x
)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{x}{Variable name in \code{data} to summarize.}

\item{w}{Optional name of the column in \code{data} with case weights.}

\item{by}{An optional vector of column names in \code{data} used to group the results.}

\item{na.rm}{Should missing values in \code{x} be removed?}

\item{value_name}{Name of the resulting column with means.}
}
\value{
A \code{data.frame} with grouped weighted means.
}
\description{
Fast version of grouped_stats(..., counts = FALSE). Works if there is at most one "by" variable.
}
\examples{
n <- 100
data <- data.frame(x = rnorm(n), w = runif(n), group = factor(sample(1:3, n, TRUE)))
grouped_weighted_mean(data, x = "x", w = "w", by = "group")
}
