% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_multi.R
\name{n_models}
\alias{n_models}
\title{Gets the dimension of \code{fixest_multi} objects}
\usage{
n_models(
  x,
  lhs = FALSE,
  rhs = FALSE,
  sample = FALSE,
  fixef = FALSE,
  iv = FALSE
)
}
\arguments{
\item{x}{A \code{fixest_mutli} object, obtained e.g. from \code{\link{feols}}.}

\item{lhs}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, the number of different
left hand sides is returned.}

\item{rhs}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, the number of different
right hand sides is returned.}

\item{sample}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, the number of different
samples is returned.}

\item{fixef}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, the number of different
types of fixed-effects is returned.}

\item{iv}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, the number of different
IV stages is returned.}
}
\value{
It returns an integer scalar. If no argument is provided, the total number of
models is returned.
}
\description{
Otabin the number of unique models of a \code{fixest_multi} object, depending on the
type requested.
}
\examples{

base = setNames(iris, c("y", "x1", "x2", "x3", "species"))
est = feols(y ~ csw(x1, x2, x3), base, fsplit = ~species)

# there are 3 different RHSs and 4 different samples
models(est)

# We can obtain these numbers with n_models
n_models(est, rhs = TRUE)
n_models(est, sample = TRUE)


}
\seealso{
Multiple estimations in \code{\link{feols}}, \code{\link{models}}
}
