% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotratecurve-class.R
\name{spotratecurve}
\alias{spotratecurve}
\alias{spotratecurve.numeric}
\alias{spotratecurve.SpotRate}
\title{Create a SpotRateCurve object}
\usage{
spotratecurve(x, terms, ..., refdate = Sys.Date())

\method{spotratecurve}{numeric}(
  x,
  terms,
  compounding,
  daycount,
  calendar,
  refdate = Sys.Date(),
  .copyfrom = NULL,
  ...
)

\method{spotratecurve}{SpotRate}(x, terms, refdate = Sys.Date(), .copyfrom = NULL, ...)
}
\arguments{
\item{x}{a numeric representing a spot rate value or a SpotRate object.}

\item{terms}{a numeric vector with positive values representing the days of
the term structure.}

\item{...}{additional arguments}

\item{refdate}{the curve reference date.}

\item{compounding}{a character with the compouning name.}

\item{daycount}{a character representing the daycount.}

\item{calendar}{a calendar object.}

\item{.copyfrom}{a SpotRate object that is used as reference to build
the SpotRateCurve object.}
}
\value{
A \code{SpotRateCurve} object.
}
\description{
\code{spotratecurve()} S3 method createas a SpotRateCurve object.
It is dispatched for numeric values, that represent spot rates and
for SpotRate objects.
}
\examples{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)

curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")

# access the term 11 days
curve[[11]]

# access the second element
curve[2]
}
