% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_univariate.R
\name{fit_univariate}
\alias{fit_univariate}
\title{Fit Univariate Distribution}
\usage{
fit_univariate(x, family, type = "continuous")
}
\arguments{
\item{x}{numeric vector}

\item{family}{character name of distribution family}

\item{type}{discrete or continuous data}
}
\value{
a fitted function family, MLE for probability distributions, custom fit for empirical (see functions)
}
\description{
Fit Univariate Distribution
}
\examples{
# Fit Discrete Distribution
fittedPois <- fit_univariate(rpois(100, 1), 'pois', 'discrete')
fittedPois$d(1)
fittedPois$p(1)
fittedPois$q(.5)
fittedPois$r(100)

# Fit Continuous Distribution
fittedExp <- fit_univariate(rexp(100, 1), 'exp')
fittedExp$d(1)
fittedExp$p(1)
fittedExp$q(.5)
fittedExp$r(100)
}
