% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{EstMLEGrassiaIIBin}
\alias{EstMLEGrassiaIIBin}
\title{Estimating the shape parameters a and b for Grassia II Binomial distribution}
\usage{
EstMLEGrassiaIIBin(x,freq,a,b,...)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{a}{single value for shape parameter a.}

\item{b}{single value for shape parameter b.}

\item{...}{mle2 function inputs except data and estimating parameter.}
}
\value{
\code{EstMLEGrassiaIIBin} here is used as a wrapper for the \code{mle2} function of \pkg{bbmle} package
therefore output is of class of mle2.
}
\description{
The function will estimate the shape parameters using the maximum log likelihood method
for the Grassia II Binomial distribution when the binomial random variables and corresponding frequencies
are given.
}
\details{
\deqn{0 < a,b}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7                   #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLEGrassiaIIBin(x=No.D.D,freq=Obs.fre.1,a=0.1,b=0.1)

bbmle::coef(parameters)         #extracting the parameters

}
\references{
\insertRef{grassia1977family}{fitODBOD}
}
