% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kumaraswamy.R
\name{fitKumBin}
\alias{fitKumBin}
\title{Fitting the Kumaraswamy Binomial Distribution when binomial random variable, frequency and shape
parameters a and b, iterations parameter it are given}
\usage{
fitKumBin(x,obs.freq,a,b,it)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing a.}

\item{b}{single value for shape parameter beta representing b.}

\item{it}{number of iterations to converge as a proper probability
function replacing infinity.}
}
\value{
The output of \code{fitKumBin} gives the class format \code{fitKB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitKB} fitted values of \code{dKumBin}.

\code{NegLL} Negative Log Likelihood value.

\code{a} estimated value for alpha parameter as a.

\code{b} estimated value for beta parameter as b.

\code{it} estimated it value for iterations.

\code{AIC} AIC value.

\code{over.dis.para} over dispersion value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fiited} can be used to
extract specific outputs.
}
\description{
The function will fit the Kumaraswamy Binomial distribution when random variables,
corresponding frequencies and shape parameters are given. It will provide the expected
frequencies, chi-squared test statistics value, p value, degree of freedom and
over dispersion value so that it can be seen if this distribution fits the data.
}
\details{
\deqn{0 < a,b}
\deqn{x = 0,1,2,...n}
\deqn{obs.freq \ge 0}
\deqn{it > 0}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7   #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)   #assigning the corresponding frequencies

\dontrun{
#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLEKumBin(x=No.D.D,freq=Obs.fre.1,a=10.1,b=1.1,it=10000)

bbmle::coef(parameters)    #extracting the parameters
aKumBin <- bbmle::coef(parameters)[1] #assigning the estimated a
bKumBin <- bbmle::coef(parameters)[2] #assigning the estimated b
itKumBin <- bbmle::coef(parameters)[3] #assigning the estimated iterations

#fitting when the random variable,frequencies,shape parameter values are given.
results <- fitKumBin(No.D.D,Obs.fre.1,aKumBin,bKumBin,itKumBin*100)
results

#extracting the expected frequencies
fitted(results)

#extracting the residuals
residuals(results)
}

}
\references{
Li, X. H., Huang, Y. Y., & Zhao, X. Y. (2011). The Kumaraswamy Binomial Distribution. Chinese Journal
of Applied Probability and Statistics, 27(5), 511-521.
}
\seealso{
\code{\link[bbmle]{mle2}}
}
