% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniform.R
\name{dUniBin}
\alias{dUniBin}
\title{Uniform Binomial Distribution}
\usage{
dUniBin(x,n)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{n}{single value for no of binomial trials}
}
\value{
The output of \code{dUniBin} gives a list format consisting

\code{pdf}            probability function values in vector form

\code{mean}           mean of the Uniform Binomial Distribution

\code{var}            variance of the Uniform Binomial Distribution

\code{ove.dis.para}   over dispersion value of Uniform Binomial Distribution
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Uniform Binomial Distribution.
}
\details{
Mixing unit bounded uniform distribution with binomial distribution will create
the Uniform Binomial Distribution. The  probability function
and cumulative probability function can be constructed and are denoted below.

The cumulative probability function is the summation of probability function values

\deqn{P_{UniBin}(x)= \frac{1}{n+1} }
\deqn{n = 1,2,...}
\deqn{x = 0,1,2,...n}

The mean, variance and over dispersion are denoted as
\deqn{E_{UniBin}[X]= \frac{n}{2} }
\deqn{Var_{UniBin}[X]= \frac{n(n+2)}{12} }
\deqn{over dispersion= \frac{1}{3} }

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
#plotting the binomial random variables and probability values
plot(0:10,dUniBin(0:10,10)$pdf,type="l",main="Uniform binomial probability function graph",
xlab=" Binomial random variable",ylab="Probability function values")
points(0:10,dUniBin(0:10,10)$pdf)
dUniBin(0:300,300)$pdf  #extracting the pdf values
dUniBin(0:10,10)$mean   #extracting the mean
dUniBin(0:10,10)$var    #extracting the variance
dUniBin(0:10,10)$over.dis.para  #extracting the over dispersion

#plotting the binomial random variables and cumulative probability values
plot(0:10,pUniBin(0:10,10),type="l",main="Cumulative probability function graph",
xlab=" Binomial random variable",ylab="Cumulative probability function values")
points(0:10,pUniBin(0:10,10))

pUniBin(0:15,15)       #acquiring the cumulative probability values

}
\references{
Horsnell, G. (1957). Economic acceptance sampling schemes. Journal of the Royal Statistical Society,
Series A, 120:148-191.

Okagbue, H. et al., 2014. Using the Average of the Extreme Values of a Triangular Distribution for a
Transformation, and Its Approximant via the Continuous Uniform Distribution. British Journal of
Mathematics & Computer Science, 4(24), pp.3497-3507.

Available at: \url{http://www.sciencedomain.org/abstract.php?iid=699&id=6&aid=6427} .
}
