% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vbgfCI_time.R
\name{vbgfCI_time}
\alias{vbgfCI_time}
\title{VBGF plot and CI}
\usage{
vbgfCI_time(
  res,
  CI = 95,
  agemax = NULL,
  plot = TRUE,
  add_legend = TRUE,
  add_max_dens_legend = TRUE,
  xlab = "Relative time",
  ylab = "Length",
  perm.col = adjustcolor("grey50", 0.1),
  perm.lwd = 1,
  ci.col = "black",
  ci.lty = 2,
  ci.lwd = 1,
  maxd.col = "black",
  maxd.lty = 1,
  maxd.lwd = 2,
  ...
)
}
\arguments{
\item{res}{Object with \eqn{L_{inf}}, \eqn{K} and \eqn{t_0}, it could be a
\code{data.frame}, a \code{tbl_df}, a \code{list}, \code{grotagBoot} or a
\code{lfqBoot} object. See Details.}

\item{CI}{\code{numeric}. Confidence interval in \% (default: 95).}

\item{agemax}{\code{numeric} values indicating the maximum number of years to
project.}

\item{plot}{\code{logical}. If \code{TRUE} (default), a plot is returned,
otherwise just a list with levels \code{limCI}, \code{inCI}, \code{density}
and \code{max_dens}. See Value for a detailed description of each one.}

\item{add_legend}{\code{logical}. Should CI and max. density legend be added
(Default: `add_legend = TRUE`).}

\item{add_max_dens_legend}{logical. Should maximum density line be added
(Default: `add_max_dens_legend = TRUE`).}

\item{xlab}{Label for x-axis}

\item{ylab}{Label for y-axis}

\item{perm.col, perm.lwd}{Color and width for each resample estimate line.}

\item{ci.col, ci.lty, ci.lwd}{Color, type and width for CI line.}

\item{maxd.col, maxd.lty, maxd.lwd}{Color, type and width for maximum density line.}

\item{...}{Extra arguments passed to the main plot function.}
}
\value{
A \code{list} containing:
\describe{
 \item{\code{$limCI}}{A \code{data.frame} with CI limits by time.}
 \item{\code{$inCI}}{A \code{data.frame} with logical values defining whether
 bootstrapping samples are within each of the defined CIs.}
 \item{\code{$density}}{The multivariate kernel density estimates for each
 sample.}
 \item{\code{$max_dens}}{A \code{list} with the VBGF parameter combination
 having the maximum density estimate.}
}
}
\description{
This function plots a swarm of von Bertalanffy growth functions
(VBGF), as length vs time (age) curves, based on the results of bootstrap
runs, with confidence intervals (CI).
}
\details{
Each thin grey line represents the output of a single bootstrap run. The most
likely optimum (i.e., the mode of the posterior distribution) is shown as a
thick black line. The dashed lines show the upper and lower limits of the 95%
confidence envelope. The input used for plotting is usually the result of a
bootstrapped growth analysis (i.e. a \code{lfqBoot} object generated by
\strong{fishboot} functions such as \link{ELEFAN_SA_boot},
\link{ELEFAN_GA_boot}, \link{grotag_boot}, or \link{grolenage_boot}).
}
\examples{
data(alba_boot) # lfqBoot object
vbgfCI_time(res = alba_boot)

vbgfCI_time(res = alba_boot, CI = c(50, 95),
            ci.col = c("red", "orange"))

data(bonito_boot) # grotagBoot object
LinfK_scatterhist(res = bonito_boot)
}
