% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_ngrams_compare_plot}
\alias{fst_ngrams_compare_plot}
\title{Plot comparison n-grams}
\usage{
fst_ngrams_compare_plot(
  table,
  number = 10,
  ngrams = 1,
  unique_colour = "indianred",
  name = NULL,
  override_title = NULL
)
}
\arguments{
\item{table}{The table of n-grams, output of `get_unique_ngrams()`.}

\item{number}{The number of n-grams, default is `10`.}

\item{ngrams}{The type of n-grams, default is `1`.}

\item{unique_colour}{Colour to display unique words, default is `"indianred"`.}

\item{name}{An optional "name" for the plot, default is `NULL`.}

\item{override_title}{An optional title to override the automatic one for
the plot. Default is `NULL`. If `NULL`, title of plot will be `number` "Most
Common 'Term'". 'Term' is "Words", "Bigrams", or "N-Grams" where N > 2.}
}
\value{
Plot of top n-grams with unique terms highlighted.
}
\description{
Plots frequency n-grams with unique n-grams highlighted.
}
\examples{
top_f <- fst_get_top_words(conllu_dev_q11_1_f_nltk)
top_m <- fst_get_top_words(conllu_dev_q11_1_m_nltk)
top_na <- fst_get_top_words(conllu_dev_q11_1_na_nltk)
topn_f <- fst_get_top_ngrams(conllu_dev_q11_1_f_nltk)
topn_m <- fst_get_top_ngrams(conllu_dev_q11_1_m_nltk)
topn_na <- fst_get_top_ngrams(conllu_dev_q11_1_na_nltk)
unique_words <- fst_get_unique_ngrams(top_f, top_m, top_na)
unique_ngrams <- fst_get_unique_ngrams(topn_f, topn_m, topn_na)
top_fu <- fst_join_unique(top_f, unique_words)
topn_mu <- fst_join_unique(topn_m, unique_ngrams)
fst_ngrams_compare_plot(top_fu, ngrams = 1, name = "Female")
fst_ngrams_compare_plot(topn_mu, ngrams = 2, name = "Male")
}
