% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_join_unique}
\alias{fst_join_unique}
\title{Merge N-grams table with unique words}
\usage{
fst_join_unique(table, unique_table)
}
\arguments{
\item{table}{Output of `fst_get_top_words()` or `fst_get_top_ngrams()`.}

\item{unique_table}{Output of `fst_get_unique_ngrams()`.}
}
\value{
A table of top n-grams, frequency, and whether the n-gram is
 "unique".
}
\description{
Merges list of unique words from `fst_get_unique_ngrams()` with output of
`fst_get_top_ngrams()` or `fst_get_top_words()` so that unique words can be
displayed on comparison plots.
}
\examples{
top_f <- fst_get_top_words(conllu_dev_q11_1_f_nltk)
top_m <- fst_get_top_words(conllu_dev_q11_1_m_nltk)
top_na <- fst_get_top_words(conllu_dev_q11_1_na_nltk)
topn_f <- fst_get_top_ngrams(conllu_dev_q11_1_f_nltk)
topn_m <- fst_get_top_ngrams(conllu_dev_q11_1_m_nltk)
topn_na <- fst_get_top_ngrams(conllu_dev_q11_1_na_nltk)
unique_words <- fst_get_unique_ngrams(top_f, top_m, top_na)
unique_ngrams <- fst_get_unique_ngrams(topn_f, topn_m, topn_na)
fst_join_unique(top_f, unique_words)
fst_join_unique(topn_m, unique_ngrams)
}
