% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_prepare_conll-u.R
\name{fst_format_conllu}
\alias{fst_format_conllu}
\title{Annotate open-ended survey responses in Finnish into CoNLL-U format}
\usage{
fst_format_conllu(data, field, model = "ftb")
}
\arguments{
\item{data}{A dataframe of survey responses which contains an open-ended
question.}

\item{field}{The field in the dataframe which contains the open-ended
question.}

\item{model}{A Finnish language model available for [udpipe], `"ftb"`
(default) or `"tdt"`.}
}
\value{
Dataframe of annotated text in CoNLL-U format.
}
\description{
Creates a dataframe in CoNLL-U format from a list of strings of Finnish text
using the [udpipe] package and a Finnish language model.
}
\examples{
\donttest{
fst_format_conllu(data = child_barometer_data, field = "q7")
fst_format_conllu(data = child_barometer_data, field = "q7", model = "tdt")
unlink("finnish-ftb-ud-2.5-191206.udpipe")
unlink("finnish-tdt-ud-2.5-191206.udpipe")
}
}
