% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{balancing_capacity_market_bids}
\alias{balancing_capacity_market_bids}
\title{Balancing Capacity Market bids}
\usage{
balancing_capacity_market_bids(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the amount of bids in the
balancing capacity market, MW/week. Fingrid procures mFRR capacity
throught the balancing capacity market on a weekly auction, which is
held when needed.
}
\description{
Check https://data.fingrid.fi/en/dataset/saatokapasiteettimarkkinat-tarjoukset
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- balancing_capacity_market_bids(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
