% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racing_helpers.R
\name{show_best.tune_race}
\alias{show_best.tune_race}
\title{Investigate best tuning parameters}
\usage{
\method{show_best}{tune_race}(x, metric = NULL, n = 5, ...)
}
\arguments{
\item{x}{The results of \code{\link[tune:tune_grid]{tune_grid()}} or \code{\link[tune:tune_bayes]{tune_bayes()}}.}

\item{metric}{A character value for the metric that will be used to sort
the models. (See
\url{https://yardstick.tidymodels.org/articles/metric-types.html} for
more details). Not required if a single metric exists in \code{x}. If there are
multiple metric and none are given, the first in the metric set is used (and
a warning is issued).}

\item{n}{An integer for the maximum number of top results/rows to return.}

\item{...}{For \code{\link[tune:select_by_one_std_err]{select_by_one_std_err()}} and \code{\link[tune:select_by_pct_loss]{select_by_pct_loss()}}, this
argument is passed directly to \code{\link[dplyr:arrange]{dplyr::arrange()}} so that the user can sort
the models from \emph{most simple to most complex}. That is, for a parameter \code{p},
pass the unquoted expression \code{p} if smaller values of \code{p} indicate a simpler
model, or \code{desc(p)} if larger values indicate a simpler model. At
least one term is required for these two functions. See the examples below.}
}
\description{
\code{\link[=show_best]{show_best()}} displays the top sub-models and their performance estimates.
}
\details{
For racing results (from the \pkg{finetune} package), it is best to only
report configurations that finished the race (i.e., were completely
resampled). Comparing performance metrics for configurations averaged with
different resamples is likely to lead to inappropriate results.
}
