% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_sim_anneal.R
\name{control_sim_anneal}
\alias{control_sim_anneal}
\title{Control aspects of the simulated annealing search process}
\usage{
control_sim_anneal(
  verbose = TRUE,
  no_improve = Inf,
  restart = 8L,
  radius = c(0.05, 0.15),
  flip = 3/4,
  cooling_coef = 0.02,
  extract = NULL,
  save_pred = FALSE,
  time_limit = NA,
  pkgs = NULL,
  save_workflow = FALSE,
  save_history = FALSE,
  event_level = "first",
  parallel_over = NULL,
  allow_par = TRUE
)
}
\arguments{
\item{verbose}{A logical for logging results (other than warnings and errors,
which are always shown) as they are generated during training in a single
R process. When using most parallel backends, this argument typically will
not result in any logging. If using a dark IDE theme, some logging messages
might be hard to see; try setting the \code{tidymodels.dark} option with
\code{options(tidymodels.dark = TRUE)} to print lighter colors.}

\item{no_improve}{The integer cutoff for the number of iterations without
better results.}

\item{restart}{The number of iterations with no improvement before new tuning
parameter candidates are generated from the last, overall best conditions.}

\item{radius}{Two real numbers on \verb{(0, 1)} describing what a value "in the
neighborhood" of the current result should be. If all numeric parameters were
scaled to be on the \verb{[0, 1]} scale, these values set the min. and max.
of a radius of a circle used to generate new numeric parameter values.}

\item{flip}{A real number between \verb{[0, 1]} for the probability of changing
any non-numeric parameter values at each iteration.}

\item{cooling_coef}{A real, positive number to influence the cooling
schedule. Larger values decrease the probability of accepting a sub-optimal
parameter setting.}

\item{extract}{An optional function with at least one argument (or \code{NULL})
that can be used to retain arbitrary objects from the model fit object,
recipe, or other elements of the workflow.}

\item{save_pred}{A logical for whether the out-of-sample predictions should
be saved for each model \emph{evaluated}.}

\item{time_limit}{A number for the minimum number of \emph{minutes} (elapsed) that
the function should execute. The elapsed time is evaluated at internal
checkpoints and, if over time, the results at that time are returned (with
a warning). This means that the \code{time_limit} is not an exact limit, but a
minimum time limit.}

\item{pkgs}{An optional character string of R package names that should be
loaded (by namespace) during parallel processing.}

\item{save_workflow}{A logical for whether the workflow should be appended
to the output as an attribute.}

\item{save_history}{A logical to save the iteration details of the search.
These are saved to \code{tempdir()} named \code{sa_history.RData}. These results are
deleted when the R session ends. This option is only useful for teaching
purposes.}

\item{event_level}{A single string containing either \code{"first"} or \code{"second"}.
This argument is passed on to yardstick metric functions when any type
of class prediction is made, and specifies which level of the outcome
is considered the "event".}

\item{parallel_over}{A single string containing either \code{"resamples"} or
\code{"everything"} describing how to use parallel processing. Alternatively,
\code{NULL} is allowed, which chooses between \code{"resamples"} and \code{"everything"}
automatically.

If \code{"resamples"}, then tuning will be performed in parallel over resamples
alone. Within each resample, the preprocessor (i.e. recipe or formula) is
processed once, and is then reused across all models that need to be fit.

If \code{"everything"}, then tuning will be performed in parallel at two levels.
An outer parallel loop will iterate over resamples. Additionally, an
inner parallel loop will iterate over all unique combinations of
preprocessor and model tuning parameters for that specific resample. This
will result in the preprocessor being re-processed multiple times, but
can be faster if that processing is extremely fast.

If \code{NULL}, chooses \code{"resamples"} if there are more than one resample,
otherwise chooses \code{"everything"} to attempt to maximize core utilization.

Note that switching between \code{parallel_over} strategies is not guaranteed
to use the same random number generation schemes. However, re-tuning a
model using the same \code{parallel_over} strategy is guaranteed to be
reproducible between runs.}

\item{allow_par}{A logical to allow parallel processing (if a parallel
backend is registered).}
}
\value{
An object of class \code{control_sim_anneal} that echos the argument values.
}
\description{
Control aspects of the simulated annealing search process
}
\examples{
control_sim_anneal()
}
