% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findtxt.R
\name{findtxt}
\alias{findtxt}
\title{Find text files by content with pattern matching}
\usage{
findtxt(pattern = "Hello World", path = ".", case.sensitive = TRUE,
  show.results = TRUE, copy = FALSE, folder = "findtxt",
  overwrite = TRUE)
}
\arguments{
\item{pattern}{a pattern (regular expression) to search for.}

\item{path}{a character vector, path to be scanned. The default corresponds to the working directory, getwd().}

\item{case.sensitive}{a logical value. If \code{TRUE}, pattern-matching is case-sensitive.}

\item{show.results}{a logical value. If \code{TRUE}, results are printed after completion.}

\item{copy}{a logical value. If \code{TRUE}, all matching text files are copied to \code{folder}.}

\item{folder}{a character vector, path or name of new folder to copy matching text files to.}

\item{overwrite}{a logical value. If \code{TRUE}, existing destination files are overwritten.}
}
\description{
\code{findtxt} scans all directories and subdirectories of a given path for text files (.txt) containing
    a specific pattern.  Hits can be copied to a new folder.
}
\examples{
# Find all text files in the package folder that contain the name Einstein
findtxt(path = system.file(package = "findR"), pattern = "Einstein")

# Save results in a data frame and show hits
dt <- findtxt(path = system.file(package = "findR"), pattern = "Einstein", show.results = TRUE)
dt

}
