% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ats.R
\name{read_ats}
\alias{read_ats}
\title{Read an ATS Acoustic Receiver File}
\usage{
read_ats(path, file, timezone = "America/Los_Angeles")
}
\arguments{
\item{path}{the path to the folder containing the desired file}

\item{file}{the path of the desired file}

\item{timezone}{the Olsen Named time zone, default is "America/Los_Angeles"}
}
\value{
A dataframe converting the raw detection data into rows of detections
}
\description{
This function takes a raw acoustic detection file generated by an ATS JSATS
receiver and processes it into a dataframe which can be used by the filtering
functions in this package.This is called within read_jsats().
}
\examples{
# Read in an ATS file
path = system.file("extdata/", package = "filteRjsats")
read_ats(path = path, file = "17111___210531_115356.csv",
timezone = "America/Los_Angeles")
# Warnings are expected due to the formatting of ATS files
}
