% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleBreak.R
\name{scaleBreak}
\alias{scale.Break}
\alias{scale.break}
\alias{scaleBreak}
\alias{scalebreak}
\title{Scatterplot with a Scale Break}
\usage{
scaleBreak(x, y, axis = 2, breakpos = 1, plot.numbers = c(1, 2), ...)
}
\arguments{
\item{x}{The x variables to be plotted.}

\item{y}{The y variables to be plotted.}

\item{axis}{Which axis should have two different scales. Currently, only implemented for "2," which is the y axis.}

\item{breakpos}{At what point should the break occur? Defaults to 1.}

\item{plot.numbers}{Which plots to include. Can be 1, 2, or c(1,2).}

\item{...}{other arguments passed to plot}
}
\description{
With skewed data, important relationships are often scaled so small because the graph attempts to capture the outliers.
\code{scaleBreak} will plot two different scales on the same plot, shrinking the range where the outliers lay. The break
in scale is indicated with a mark.
}
\examples{
# generate correlated data
d = data.frame(mvrnorm(1000, mu=c(0,0), Sigma=matrix(c(1,.6,.6,1), nrow=2)))
names(d) = c("x","y")
## Skew Y
d$y = d$y^2
scaleBreak(d$x, d$y, breakpos=4, plot.numbers=1)
## add a lowess line
lines(lowess(d$x, d$y), col="red")
## add a fitted line
mod = glm(y~x, data=d, family=inverse.gaussian)
curve(predict(mod,data.frame(x=x),type="resp"),add=TRUE,col="blue")
## add second plot
scaleBreak(d$x, d$y, breakpos=4, plot.numbers=2)
}
\author{
Dustin Fife
}

