% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFields.R
\name{extractFields}
\alias{extractFields}
\title{extractFields}
\usage{
extractFields(x)
}
\arguments{
\item{x}{Object of class \emph{RasterLayer}.}
}
\value{
A \emph{SpatialPolygonsDataFrame}.
}
\description{
Extracts and vectorizes clumps of pixels with equal value within a raster object.
}
\details{
{Given a segmented image as \emph{x}, the function extracts patches of pixels with equal value. For each 
pixel region, the function extracts the center pixel coordinates and derives their minimum convex polygon. Then, 
for each polygon, the derives a ratio between the area of the polygon and the area of the pixel region. Ratios 
below zero suggest that the region has a clearly defined shape (e.g. rectangular). Clumps is less than 3 points 
are ignored. The output of the function is a \emph{SpatialPolygonsDataFrame} reporting on:
\itemize{
 \item{\emph{Region ID} - Unique polygon identifier.}
 \item{\emph{Area} - Polygon Area (in square meters).}
 \item{\emph{Perimeter} - Polygon perimeter (in square meters).}
 \item{\emph{Pixel \%} - Percentage of non-NA pixels.}}}
}
\examples{
{

require(raster)

# read raster data
r <- brick(system.file("extdata", "ndvi.tif", package="fieldRS"))

# spatial change labeling
or <- ccLabel(r[[1]], method="spatial", change.threshold=10)$regions

# convert to polygons and plot
ef <- extractFields(or)
plot(ef)

}
}
