% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\docType{data}
\name{medication_bundles}
\alias{medication_bundles}
\title{Exemplary FHIR bundles}
\format{
List of length 3 containing \emph{serialized} "xml_document" objects, each representing one bundle from a
FHIR search request. \emph{They have to be unserialized before use, see Examples!}
}
\source{
Generated by

\code{
fhir_search("https://hapi.fhir.org/baseR4/MedicationStatement?
code=http://snomed.info/ct|429374003&
_include=MedicationStatement:subject", max.bundles = 3)
}

[Downloaded 06-22-20]
}
\usage{
medication_bundles
}
\description{
This data example can be used to explore some of the functions from the fhircrackr package
when direct access to a FHIR server is not possible.
}
\details{
medication_bundles is a list of \emph{serialized} xml objects representing FHIR bundles as returned by fhir_search().

It contains 3 bundles with MedicationStatement resources representing Medications with Snomed CT code
429374003 and the respective Patient resources that are linked to these MedicationStatements.

It corresponds to the example of downloading and flattening FHIR resources from the vignette of the package.
}
\examples{
#unserialize xml objects before doing anything else with them!
medication_bundles <- fhir_unserialize(medication_bundles)


}
\keyword{datasets}
