% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fgeo.R
\name{read_vft}
\alias{read_vft}
\alias{read_taxa}
\title{Import \emph{ViewFullTable} or \emph{ViewTaxonomy} data from a .tsv or .csv file.}
\usage{
read_vft(file, delim = NULL, na = c("", "NA", "NULL"), ...)

read_taxa(file, delim = NULL, na = c("", "NA", "NULL"), ...)
}
\arguments{
\item{file}{A path to a file.}

\item{delim}{Single character used to separate fields within a record. The
default (\code{delim = NULL}) is to guess between comma or tab (\code{","} or \code{"\t"}).}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{...}{Other arguments passed to \code{\link[readr:read_delim]{readr::read_delim()}}.}
}
\value{
A \link[tibble:tibble-package]{tibble}.
}
\description{
\code{\link[=read_vft]{read_vft()}} and \code{\link[=read_taxa]{read_taxa()}} help you to read \emph{ViewFullTable} and
\emph{ViewTaxonomy} data from text files delivered by the ForestGEO database.
These functions avoid common problems about column separators, missing
values, column names, and column types.
}
\section{Acknowledgments}{

Thanks to Shameema Jafferjee Esufali for inspiring the feature that
automatically detects \code{delim} (issue 65).
}

\examples{
assert_is_installed("fgeo.x")
library(fgeo.x)

example_path()

file_vft <- example_path("view/vft_4quad.csv")
read_vft(file_vft)

file_taxa <- example_path("view/taxa.csv")
read_taxa(file_taxa)
}
\seealso{
\code{\link[readr:read_delim]{readr::read_delim()}}, \code{\link[=type_vft]{type_vft()}}, \code{\link[=type_taxa]{type_taxa()}}.

Other functions to read text files delivered by ForestgGEO's database: \code{\link{type_vft}}
}
\concept{functions to import ForestGEO data}
\concept{functions to import a single file of ForestGEO data}
\concept{functions to read text files delivered by ForestgGEO's database}
