% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processVectorsR.R
\name{computeFFFMean}
\alias{computeFFFMean}
\title{Quick computation of FFF mean of a given vector}
\usage{
computeFFFMean(x = c(0), lambda = 0.99)
}
\arguments{
\item{x}{Vector of numeric values values. Default is \code{c(0)}, 
a vector of one element (zero)}

\item{lambda}{Value for the fixed forgetting factor in \eqn{[0,1]}.
Default is \code{lambda=0.99}.}
}
\description{
Given a vector \code{x} and a value \code{lambda} for a fixed forgetting
factor, returns the value of the fixed forgetting factor mean
\eqn{\bar{x}_{N, \lambda}}, where \eqn{N} is the length of \code{x}.
Algorithm is implemented in C++.
}
\section{Author}{

Dean Bodenham
}

\section{References}{

D. A. Bodenham and N. M. Adams (2016) 
\emph{Continuous monitoring for changepoints in data 
streams using adaptive estimation}. 
Statistics and Computing  
doi:10.1007/s11222-016-9684-8
}
\seealso{
\code{\link{computeAFFMean}}
}

