% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/flea_starters.R,
%   R/mfl_starters.R, R/sleeper_starters.R
\name{ff_starters}
\alias{ff_starters}
\alias{ff_starters.flea_conn}
\alias{ff_starters.mfl_conn}
\alias{ff_starters.sleeper_conn}
\title{Get Starting Lineups}
\usage{
ff_starters(conn, ...)

\method{ff_starters}{flea_conn}(conn, week = 1:17, ...)

\method{ff_starters}{mfl_conn}(conn, week = "all", season = NULL, ...)

\method{ff_starters}{sleeper_conn}(conn, week = 1:17, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{other arguments (currently unused)}

\item{week}{a numeric or one of YTD (year-to-date) or AVG (average to date)}

\item{season}{the season of interest - generally only the most recent 2-3 seasons are available}
}
\value{
A tidy dataframe with every player for every week, including a flag for whether they were started or not
}
\description{
This function returns a tidy dataframe with one row for every starter (and bench) for every week and their scoring, if available.
}
\section{Methods (by class)}{
\itemize{
\item \code{flea_conn}: Fleaflicker: returns who was started as well as what they scored.

\item \code{mfl_conn}: MFL: returns the player fantasy scores for each week (not the actual stats)

\item \code{sleeper_conn}: Sleeper: returns only "who" was started, without any scoring/stats data. Only returns season specified in initial connection object.
}}

\examples{
\donttest{
conn <- fleaflicker_connect(season = 2020, league_id = 206154)
ff_starters(conn)
}

\donttest{
dlf_conn <- mfl_connect(2020, league_id = 37920)
ff_starters(conn = dlf_conn, week = 1:2)
}

\donttest{
jml_conn <- sleeper_connect(league_id = "522458773317046272", season = 2020)
jml_starters <- ff_starters(jml_conn)
}

}
